<?php
declare(strict_types=1);

require_once __DIR__ . '/../core.php';

class ChaturbateFetcher implements SiteFetcher {
    public static function canHandle(string $url): bool {
        return preg_match('~chaturbate\.com/~i', $url) === 1;
    }

    public static function fetchMedia(string $url): array {
        // تلاش برای یافتن لینک HLS (m3u8) در HTML یا اسکریپت‌ها
        $html = httpGet($url, [
            "User-Agent: Mozilla/5.0 (ChaturbateFetcher/1.0)",
            "Accept: */*",
            "Referer: $url",
        ]);

        // الگوهای رایج: hlsurl:"https://.../playlist.m3u8"
        // یا "https://...m3u8" در جاوااسکریپت
        $m3u8 = null;
        if (preg_match('~hlsurl\s*:\s*["\']([^"\']+\.m3u8[^"\']*)["\']~i', $html, $m)) {
            $m3u8 = html_entity_decode($m[1]);
        }
        if (!$m3u8 && preg_match('~["\']([^"\']+\.m3u8[^"\']*)["\']~i', $html, $m2)) {
            $m3u8 = html_entity_decode($m2[1]);
        }

        if (!$m3u8) {
            throw new RuntimeException('❌ لینک HLS (m3u8) برای پخش زنده پیدا نشد.');
        }

        $author = sanitizeSlug(parse_url($url, PHP_URL_HOST) ?? 'chaturbate');
        $title  = sanitizeSlug(basename(parse_url($url, PHP_URL_PATH) ?? 'live'));

        // نوع را live می‌گذاریم تا دانلودر مسیر ضبط یا ثبت را اجرا کند
        return [[
            'url'    => $m3u8,
            'type'   => 'live',
            'author' => $author,
            'title'  => $title,
            'ext'    => 'mp4', // خروجی مطلوب ضبط
        ]];
    }
}