<?php
declare(strict_types=1);
require_once __DIR__ . '/core.php';
require_once __DIR__ . '/fetchers.php';

$items = loadAllMedia();

// پارامترها
$perPage = (int)($_GET['perPage'] ?? 30);
$page    = max(1, (int)($_GET['page'] ?? 1));
$sort    = $_GET['sort'] ?? 'new';
$author  = trim($_GET['author'] ?? '');
$linkId  = trim($_GET['linkId'] ?? '');
$q       = trim($_GET['q'] ?? ''); // جستجو

// گروه‌بندی: دامنه → لینک‌ها
$grouped = [];
foreach ($items as $it) {
    $a = $it['author'] ?? 'unknown';
    $l = $it['linkId'] ?? 'link';
    if (!isset($grouped[$a])) $grouped[$a] = [];
    if (!isset($grouped[$a][$l])) $grouped[$a][$l] = [];
    $grouped[$a][$l][] = $it;
}

// فیلتر دامنه
if ($author !== '') {
    $items = [];
    if (isset($grouped[$author])) {
        if ($linkId !== '') {
            $items = $grouped[$author][$linkId] ?? [];
        } else {
            foreach ($grouped[$author] as $lid => $list) {
                $items[] = [
                    'author' => $author,
                    'linkId' => $lid,
                    'thumb'  => getSiteLogo('https://' . $author),
                    'count'  => $list[0]['count'] ?? count($list),
                    'size'   => $list[0]['size'] ?? 0,
                    'page'   => $list[0]['page'] ?? '',
                ];
            }
        }
    }
}

// فیلتر جستجو
if ($q !== '' && $linkId !== '') {
    $items = array_values(array_filter($items, function ($it) use ($q) {
        return mb_stripos($it['title'] ?? '', $q) !== false || mb_stripos($it['name'] ?? '', $q) !== false;
    }));
}

// مرتب‌سازی
switch ($sort) {
    case 'new':  usort($items, fn($a,$b) => strcmp($b['name'] ?? '', $a['name'] ?? '')); break;
    case 'old':  usort($items, fn($a,$b) => strcmp($a['name'] ?? '', $b['name'] ?? '')); break;
    case 'alpha':usort($items, fn($a,$b) => strcmp(mb_strtolower($a['title'] ?? ''), mb_strtolower($b['title'] ?? ''))); break;
    default:     usort($items, fn($a,$b) => strcmp($b['name'] ?? '', $a['name'] ?? '')); break;
}

$total   = count($items);
$pages   = max(1, (int)ceil($total / $perPage));
$start   = ($page - 1) * $perPage;
$view    = ($linkId !== '') ? array_slice($items, $start, $perPage) : $items;

function authorProfileThumb(array $links, string $author): string {
    $logo = getSiteLogo('https://' . $author);
    if ($logo) return $logo;
    foreach ($links as $list) {
        foreach ($list as $it) {
            if (!empty($it['thumb'])) return $it['thumb'];
            if (($it['type'] ?? '') === 'image' && !empty($it['path'])) return $it['path'];
        }
    }
    return 'assets/profile-placeholder.png';
}
?>
<!doctype html>
<html lang="fa">
<head>
    <meta charset="utf-8">
    <title>گالری رسانه‌ها</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="assets/styles.css">
    <script src="assets/scripts.js?v=20251111" defer></script>
</head>
<body>
<header>
    <h1>گالری</h1>
    <nav><a href="gallery.php">خانه</a> · <a href="index.php">دانلود جدید</a></nav>
</header>

<main>
    <!-- فرم وارد کردن لینک -->
    <form id="downloadForm" class="top-form">
        <input type="url" id="url" name="url" placeholder="https://..." required>
        <button type="submit">دانلود</button>
    </form>

    <!-- سکشن پیشرفت -->
    <section id="progressSection" class="hidden">
        <h2 style="text-align:center;">پیشرفت دانلود</h2>
        <div class="gauges">
            <canvas id="speedGauge" width="200" height="200"></canvas>
            <canvas id="progressGauge" width="200" height="200"></canvas>
        </div>
        <div id="progressInfo" style="text-align:center;margin-top:12px;"></div>
    </section>

    <!-- گالری -->
    <section class="grid">
        <?php if ($author === ''): ?>
            <!-- پروفایل دامنه‌ها -->
            <?php foreach ($grouped as $a => $links): ?>
                <div class="cell profile">
                    <a class="profile-link" href="?author=<?php echo urlencode($a); ?>">
                        <img class="thumb-img" src="<?php echo htmlspecialchars(authorProfileThumb($links, $a)); ?>" alt="profile" loading="lazy">
                        <div class="name"><?php echo htmlspecialchars(preg_replace('~^www\.~','',$a)); ?> (<?php echo count($links); ?> لینک)</div>
                    </a>
                    <div class="actions">
                        <button class="danger btn-delete-author" data-author="<?php echo htmlspecialchars($a); ?>">حذف پروفایل سایت</button>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php elseif ($linkId === ''): ?>
            <!-- پروفایل لینک‌های یک دامنه -->
            <?php foreach ($items as $link): ?>
                <div class="cell profile">
                    <a class="profile-link" href="?author=<?php echo urlencode($author); ?>&linkId=<?php echo urlencode($link['linkId']); ?>">
                        <img class="thumb-img" src="<?php echo htmlspecialchars($link['thumb']); ?>" alt="link" loading="lazy">
                        <div class="name">لینک: <?php echo htmlspecialchars($link['linkId']); ?></div>
                    </a>
                    <div class="details">
                        <div class="detail-row"><span class="label">آدرس:</span>
                            <a href="<?php echo htmlspecialchars($link['page']); ?>" target="_blank" rel="noopener noreferrer"><?php echo htmlspecialchars($link['page']); ?></a>
                        </div>
                        <div class="detail-row"><span class="label">تعداد:</span><span><?php echo (int)$link['count']; ?></span></div>
                        <div class="detail-row"><span class="label">حجم:</span><span><?php echo round(((float)$link['size'])/1024/1024,2); ?> MB</span></div>
                    </div>
                    <div class="actions">
                        <button class="danger btn-delete-link"
                                data-author="<?php echo htmlspecialchars($author); ?>"
                                data-linkid="<?php echo htmlspecialchars($link['linkId']); ?>">
                            حذف پوشه لینک
                        </button>
                    </div>
                </div>
            <?php endforeach; ?>
            <p style="text-align:center;margin-top:12px;"><a href="gallery.php">بازگشت به لیست دامنه‌ها</a></p>
        <?php else: ?>

            <!-- مدیاهای یک لینک -->
            <?php foreach ($view as $it): ?>
                <div class="cell"
                     data-type="<?php echo htmlspecialchars($it['type']); ?>"
                     data-src="<?php echo htmlspecialchars($it['path']); ?>">
                    <?php if (($it['type'] ?? '') === 'video'): ?>
                        <video class="thumb-img" src="<?php echo htmlspecialchars($it['path']); ?>" muted playsinline></video>
                    <?php else: ?>
                        <img class="thumb-img" src="<?php echo htmlspecialchars($it['thumb'] ?: $it['path']); ?>" alt="thumb" loading="lazy">
                    <?php endif; ?>
                    <div class="name"><?php echo htmlspecialchars($it['title'] ?: basename($it['path'])); ?></div>
                    <div class="actions">
                        <button class="danger btn-delete-file" data-file="<?php echo htmlspecialchars($it['path']); ?>">حذف فایل</button>
                    </div>
                </div>
            <?php endforeach; ?>

            <!-- صفحه‌بندی -->
            <div class="pagination">
                <?php for($i=1;$i<=$pages;$i++): ?>
                    <a href="?page=<?php echo $i; ?>&perPage=<?php echo $perPage; ?>&sort=<?php echo urlencode($sort); ?>&author=<?php echo urlencode($author); ?>&linkId=<?php echo urlencode($linkId); ?>&q=<?php echo urlencode($q); ?>"
                       class="<?php if($i==$page) echo 'active'; ?>"><?php echo $i; ?></a>
                <?php endfor; ?>
            </div>

            <p style="text-align:center;margin-top:12px;">
                <a href="?author=<?php echo urlencode($author); ?>">بازگشت به لینک‌های دامنه</a>
            </p>
        <?php endif; ?>
    </section>

    <!-- ویوئر -->
    <div id="viewer" class="viewer hidden" aria-hidden="true">
        <button id="closeBtn" class="close" title="بستن">×</button>
        <button id="prevBtn" class="nav prev" title="قبلی">‹</button>
        <button id="nextBtn" class="nav next" title="بعدی">›</button>
        <div id="player"></div>
        <button id="deleteBtn" class="delete danger" title="حذف">حذف</button>
    </div>

    <!-- Modal تأیید حذف -->
    <div id="confirmModal" class="modal hidden" aria-hidden="true">
        <div class="modal-content">
            <h3>حذف محتوا</h3>
            <p id="confirmText">آیا مطمئن هستی که می‌خواهی حذف کنی؟</p>
            <div class="modal-actions">
                <button id="confirmOk" class="danger">مطمئن هستم</button>
                <button id="confirmCancel" class="secondary">انصراف</button>
            </div>
        </div>
    </div>

    <!-- Modal انتخاب نوع محتوا (شیشه‌ای) -->
    <div id="contentTypeModal" class="modal hidden" aria-hidden="true">
        <div class="modal-content">
            <h3>انتخاب نوع محتوا</h3>
            <p class="muted">نوع محتوای لینک را انتخاب کن:</p>
            <div style="margin-top:8px;">
                <select id="contentTypeSelect" class="glass-select">
                    <option value="image">تصاویر</option>
                    <option value="video">ویدئو</option>
                    <option value="audio">صوت</option>
                    <option value="gif">گیف</option>
                    <option value="pdf">PDF</option>
                    <option value="other">سایر</option>
                </select>
            </div>
            <div class="modal-actions" style="margin-top:12px;">
                <button id="contentTypeOk" class="secondary">ادامه</button>
                <button id="contentTypeCancel" class="secondary">انصراف</button>
            </div>
        </div>
    </div>

</main>
</body>
</html>