<?php
declare(strict_types=1);

require_once __DIR__ . '/core.php';

header('Content-Type: application/json; charset=utf-8');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit;
}

$action = trim($_POST['action'] ?? ''); // file | link | author
$target = trim($_POST['target'] ?? ''); // مسیر یا شناسه
$author = trim($_POST['author'] ?? '');
$linkId = trim($_POST['linkId'] ?? '');

if ($action === '') {
    http_response_code(400);
    echo json_encode(['error' => 'هیچ عملیاتی مشخص نشده است.']);
    exit;
}

try {
    $result = false;

    switch ($action) {
        case 'file':
            // حذف فایل تکی
            if ($target === '') throw new RuntimeException('مسیر فایل مشخص نشده.');
            $result = deleteFileSafe($target);
            break;

        case 'link':
            // حذف پروفایل لینک
            if ($author === '' || $linkId === '') throw new RuntimeException('شناسه لینک یا نویسنده مشخص نشده.');
            $result = deleteLinkProfile($author, $linkId);
            break;

        case 'author':
            // حذف پروفایل سایت
            if ($author === '') throw new RuntimeException('شناسه نویسنده مشخص نشده.');
            $result = deleteAuthorProfile($author);
            break;

        default:
            throw new RuntimeException('نوع عملیات نامعتبر است.');
    }

    if ($result) {
        echo json_encode([
            'success' => true,
            'message' => '✅ حذف با موفقیت انجام شد.'
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'message' => '❌ حذف انجام نشد.'
        ]);
    }

} catch (Throwable $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
    exit;
}